# <qrucible>
# name = Path Corners
# desc = Creates a set of connected path corners, optionally looped.
# compat = q1
#
# param = target_prefix,Target Prefix,text,t_,_
# param = num_corners,Number of Corners,number,3,2|256
# param = looped,Looped,checkbox,True,_
#
#
# </qrucible>

from qrucible_plugin import *

template_path_corner = """
{
"classname" "path_corner"
"origin" "$x$ 0 0"
"target" "$target$"
"targetname" "$targetname$"
}
"""

def main():
	qcrucible_init()

	next_target_num = qrucible_get_next_target_num()

	results_text = ""

	num_corners = int(qparams["num_corners"])
	is_looped = qparams["looped"] == "true"

	for step in range(0, num_corners):

		body_text = template_path_corner

		if step == num_corners - 1:

			if is_looped:

				# if the path is looped, the last corner will be connected to
				# the first corner
				body_text = body_text.replace("$target$", qrucible_make_target_name(next_target_num + step + 1 - num_corners))
			else:

				# if the path is not looped, the last corner will not be
				# connected to anything, so remove the target line
				body_text = body_text.replace('\n"target" "$target$"', '')

		else:

			body_text = body_text.replace("$target$", qrucible_make_target_name(next_target_num + step + 1))

		body_text = body_text.replace("$targetname$", qrucible_make_target_name(next_target_num + step))
		body_text = body_text.replace("$x$", str(step * 32))
		results_text += body_text

	print(results_text)
	qrucible_emit_success()

if __name__ == "__main__":
	main()
