# <qrucible>
#   name = Terrain Brush
#   desc = Creates triangulated brushes with n-subdivisions
# compat = q1
#
#   param = width,Width (X),number,128,1|4096s
#   param = width_div,Divisions,number,2,1|256
#   param = depth,Depth (Y),number,128,1|4096
#   param = depth_div,Divisions,number,2,1|256
#   param = height,Height (Z),number,32,1|4096
#   param = height_div,Divisions,number,1,1|256
#   param = alt_tri,Alternate Triangles?,checkbox,false,_
# </qrucible>

from qrucible_plugin import *

template_brush_header = """
{
"mapversion" "220"
"classname" "worldspawn"
"""

# This is a 1-unit brush at the world origin. It gets scaled and duped to create
# the tessellated brush.

template_brush = """
{
	( -0.5 -64 -16 ) ( -0.5 -63 -16 ) ( -0.5 -64 -15 ) skip [ 0 -1 0 0 ] [ -0 -0 -1 0 ] 0 1 1
	( -64 -64 -0.5 ) ( -63 -64 -0.5 ) ( -64 -63 -0.5 ) skip [ -1 0 0 0 ] [ -0 -1 -0 0 ] 0 1 1
	( 64 64 0.5 ) ( 64 65 0.5 ) ( 65 64 0.5 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
	( 64 0.5 16 ) ( 65 0.5 16 ) ( 64 0.5 17 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
	( 0.5 0.5 0 ) ( -0.5 -0.5 0 ) ( -0.5 -0.5 128 ) skip [ 0.7 0.7 -0 0 ] [ 0 -0 -1 0 ] 0 1 1
}
{
	( 0.5 0.5 0 ) ( -0.5 -0.5 128 ) ( -0.5 -0.5 0 ) skip [ -0.7 -0.7 0 0 ] [ -0 0 -1 0 ] 0 1 1
	( -64 -0.5 -16 ) ( -64 -0.5 -15 ) ( -63 -0.5 -16 ) skip [ 1 0 -0 0 ] [ 0 -0 -1 0 ] 0 1 1
	( -64 -64 -0.5 ) ( -63 -64 -0.5 ) ( -64 -63 -0.5 ) skip [ -1 0 0 0 ] [ -0 -1 -0 0 ] 0 1 1
	( 64 64 0.5 ) ( 64 65 0.5 ) ( 65 64 0.5 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
	( 0.5 64 16 ) ( 0.5 64 17 ) ( 0.5 65 16 ) skip [ 0 1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
"""

template_brush_alt = """
{
	( 0.5 -0.5 0 ) ( -0.5 0.5 0 ) ( -0.5 0.5 128 ) skip [ 0.7 -0.7 0 0 ] [ 0 -0 -1 0 ] 0 1 1
	( -64 64 -0.5 ) ( -64 63 -0.5 ) ( -63 64 -0.5 ) skip [ -1 0 0 0 ] [ -0 -1 -0 0 ] 0 1 1
	( 64 -64 0.5 ) ( 65 -64 0.5 ) ( 64 -65 0.5 ) skip [ 1 -0 0 0 ] [ -0 -1 0 0 ] 0 1 1
	( -64 0.5 -16 ) ( -63 0.5 -16 ) ( -64 0.5 -15 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
	( 0.5 -64 16 ) ( 0.5 -65 16 ) ( 0.5 -64 17 ) skip [ -0 1 0 0 ] [ -0 0 -1 0 ] 0 1 1
}
{
	( -0.5 64 -16 ) ( -0.5 64 -15 ) ( -0.5 63 -16 ) skip [ 0 -1 0 0 ] [ -0 -0 -1 0 ] 0 1 1
	( 64 -0.5 16 ) ( 64 -0.5 17 ) ( 65 -0.5 16 ) skip [ 1 0 -0 0 ] [ 0 -0 -1 0 ] 0 1 1
	( -64 64 -0.5 ) ( -64 63 -0.5 ) ( -63 64 -0.5 ) skip [ -1 0 0 0 ] [ -0 -1 -0 0 ] 0 1 1
	( 64 -64 0.5 ) ( 65 -64 0.5 ) ( 64 -65 0.5 ) skip [ 1 -0 0 0 ] [ -0 -1 0 0 ] 0 1 1
	( 0.5 -0.5 0 ) ( -0.5 0.5 128 ) ( -0.5 0.5 0 ) skip [ -0.7 0.7 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
"""

# takes a vertex in the string format : "( x y z )", applies transforms, and
# returns as a string in the same format

def transform_vertex(_vertex_str: str,
                     _width: float, _height: float, _depth: float,
                     _x_offset: float = 0.0, _y_offset: float = 0.0, _zoffset: float = 0.0
                 ) -> str:

	coords = [float(x) for x in _vertex_str.strip('() ').split()]
	coords[0] = coords[0] * _width + _x_offset
	coords[1] = coords[1] * _height + _y_offset
	coords[2] = coords[2] * _depth + _zoffset
	return f"( {coords[0]} {coords[1]} {coords[2]} )"

def main():
	qcrucible_init()

	# header

	results_text = template_brush_header

	# parse args

	width = float(qparams["width"])
	width_div = int(qparams["width_div"])
	depth = float(qparams["depth"])
	depth_div = int(qparams["depth_div"])
	height = float(qparams["height"])
	height_div = int(qparams["height_div"])
	alt_tri = True if qparams["alt_tri"] == "true" else False

	# generate brushes

	width_step = width / width_div
	depth_step = depth / depth_div
	height_step = height / height_div

	for x in range(width_div):
		for y in range(depth_div):
			for z in range(height_div):
				if alt_tri and ((x + y) % 2 == 0):
					brush_text = template_brush_alt
				else:
					brush_text = template_brush

				vertices_pattern = r'\(\s*-?\d+\.?\d*\s+-?\d+\.?\d*\s+-?\d+\.?\d*\s*\)'
				brush_text = re.sub(vertices_pattern,
				                    lambda m: transform_vertex(m.group(),
				                                               width_step,
				                                               depth_step,
				                                               height_step,
				                                               x * width_step, y * depth_step, z * height_step),
				                    brush_text)
				results_text += brush_text

	# footer
	results_text += "}"

	print(results_text)
	qrucible_emit_success()


if __name__ == "__main__":
	main()


