import argparse
import re
import sys

SUCCESS = 0
FAILURE = 1

QUAKE1 = 0
QUAKE2 = 1
QUAKE3 = 2

# global location to read parameters from

qparams = {}

# parses the arguments passed in via "--set" and creates a dictionary

def qcrucible_init():

	parser = argparse.ArgumentParser()
	parser.add_argument("--set", metavar='KEY=VALUE', action="append", type=qrucible_kv, default=[])

	qparams.clear()
	qparams.update(dict(parser.parse_args().set))

# breaks out key/value pairs from strings

def qrucible_kv(s: str) -> tuple[str, str]:
	if "=" not in s:
		raise argparse.ArgumentTypeError("use key=value")
	k, v = s.split("=", 1)
	return k, v

def qrucible_emit_success(message):
	print("QRUCIBLE:1," + message)
	sys.exit(SUCCESS)

def qrucible_emit_failure(message):
	print("QRUCIBLE:0," + message)
	sys.exit(FAILURE)

def qrucible_find_highest_target_num() -> tuple[bool, int]:
	try:
		highest_target = 0
		kv_re = re.compile(r'"\s*([^"]+)\s*"\s*"\s*([^"]*)\s*"')
		prefix = qparams["target_prefix"]
		val_re = re.compile(rf'^{re.escape(prefix)}(\d+)$')

		with open(qparams["map_name"], 'r', encoding='utf-8', errors='ignore') as f:
			for line in f:
				m = kv_re.search(line)
				if not m:
					continue

				key, value = m.group(1), m.group(2)
				if 'target' in key.lower():
					m2 = val_re.match(value)
					if not m2:
						continue
					target_num = int(m2.group(1))
					highest_target = max(highest_target, target_num)

		return True, highest_target
	except Exception:
		return False, -1

def qrucible_find_next_target_num() -> tuple[bool, int]:

	result, highest_target = qrucible_find_highest_target_num()

	if result:
		return True, highest_target + 1
	else:
		return False, -1

def qrucible_make_target_name(_num) -> str:
	return qparams["target_prefix"] + str(_num)


# script tips:
#
# to check for a specific game_id:
#
# 	if int(qparams["game_id"]) != QUAKE1:
# 		qrucible_emit_failure("This plugin only works for Quake 1.")
# 		return

