
# {
#   name = Unique Target
#   desc = Generates a unique target in [prefix]# format.
#
#   param = target_prefix,Target Prefix,text,t_,7
# }

from qrucible_plugin import *

def main():

	qcrucible_init()

	# find the highest target in use at the moment using the specific prefix

	result, next_target_num = qrucible_find_next_target_num()

	if result:

		# create new target that is one higher and return it

		new_target = qrucible_make_target_name(next_target_num)

		print(new_target)
		qrucible_emit_success(f"Copied to clipboard ({new_target}).")

	qrucible_emit_failure(f"Error parsing file {qparams['map_name']}")

if __name__ == "__main__":
	main()
