
# {
#   name = Monster Teleporter
#   desc = Sets up a triggered, teleporting monster.
#
#   param = target_prefix,Target Prefix,text,t_,_
#   param = monster_class,Monster Class,optionbutton,army,army|demon1|dog|enforcer|fish|hell_knight|knight|ogre|shalrath|shambler|tarbaby|wizard
#   param = spawn_angry,Spawn Angry,checkbox,True,_
# }

from qrucible_plugin import *

template_tele_monster = """
{
"mapversion" "220"
"classname" "worldspawn"
{
( -48 -32 -32 ) ( -48 -31 -32 ) ( -48 -32 -31 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -32 -48 -32 ) ( -32 -48 -31 ) ( -31 -48 -32 ) skip [ 1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -32 -32 -32 ) ( -31 -32 -32 ) ( -32 -31 -32 ) skip [ -1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 -16 ) ( 64 49 -16 ) ( 65 48 -16 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 -16 ) ( 65 48 -16 ) ( 64 48 -15 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 48 48 -16 ) ( 48 48 -15 ) ( 48 49 -16 ) skip [ 0 1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
{
( -48 -32 80 ) ( -48 -31 80 ) ( -48 -32 81 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -32 -48 80 ) ( -32 -48 81 ) ( -31 -48 80 ) skip [ 1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 64 48 96 ) ( 65 48 96 ) ( 64 49 96 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 112 ) ( 64 49 112 ) ( 65 48 112 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 96 ) ( 65 48 96 ) ( 64 48 97 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 48 48 96 ) ( 48 48 97 ) ( 48 49 96 ) skip [ 0 1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
{
( -64 -32 80 ) ( -64 -31 80 ) ( -64 -32 81 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -32 -48 80 ) ( -32 -48 81 ) ( -31 -48 80 ) skip [ 1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 64 48 -32 ) ( 65 48 -32 ) ( 64 49 -32 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 112 ) ( 64 49 112 ) ( 65 48 112 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 96 ) ( 65 48 96 ) ( 64 48 97 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -48 -32 80 ) ( -48 -32 81 ) ( -48 -31 80 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
{
( 48 -32 80 ) ( 48 -31 80 ) ( 48 -32 81 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 80 -48 80 ) ( 80 -48 81 ) ( 81 -48 80 ) skip [ 1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 176 48 -32 ) ( 177 48 -32 ) ( 176 49 -32 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 176 48 112 ) ( 176 49 112 ) ( 177 48 112 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 176 48 96 ) ( 177 48 96 ) ( 176 48 97 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 64 -32 80 ) ( 64 -32 81 ) ( 64 -31 80 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
{
( -64 32 80 ) ( -64 32 81 ) ( -64 31 80 ) skip [ 0 1 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -48 48 80 ) ( -48 48 81 ) ( -47 48 80 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 32 -64 -32 ) ( 32 -65 -32 ) ( 33 -64 -32 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 32 -64 112 ) ( 33 -64 112 ) ( 32 -65 112 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( -48 64 80 ) ( -47 64 80 ) ( -48 64 81 ) skip [ 1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 64 -64 96 ) ( 64 -65 96 ) ( 64 -64 97 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
{
( -64 -80 80 ) ( -64 -80 81 ) ( -64 -81 80 ) skip [ 0 1 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -48 -64 80 ) ( -48 -64 81 ) ( -47 -64 80 ) skip [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 32 -176 -32 ) ( 32 -177 -32 ) ( 33 -176 -32 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 32 -176 112 ) ( 33 -176 112 ) ( 32 -177 112 ) skip [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( -48 -48 80 ) ( -47 -48 80 ) ( -48 -48 81 ) skip [ 1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 64 -176 96 ) ( 64 -177 96 ) ( 64 -176 97 ) skip [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
}
{
"classname" "trigger_teleport"
"target" "$teleport_dest_tag$"
"targetname" "$teleport_tag$"
{
( -48 -32 -16 ) ( -48 -31 -16 ) ( -48 -32 -15 ) trigger [ 0 -1 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -32 -48 -16 ) ( -32 -48 -15 ) ( -31 -48 -16 ) trigger [ 1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( -32 -32 -16 ) ( -31 -32 -16 ) ( -32 -31 -16 ) trigger [ -1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 0 ) ( 64 49 0 ) ( 65 48 0 ) trigger [ 1 0 0 0 ] [ 0 -1 0 0 ] 0 1 1
( 64 48 0 ) ( 65 48 0 ) ( 64 48 1 ) trigger [ -1 0 0 0 ] [ 0 0 -1 0 ] 0 1 1
( 48 48 0 ) ( 48 48 1 ) ( 48 49 0 ) trigger [ 0 1 0 0 ] [ 0 0 -1 0 ] 0 1 1
}
}
{
"classname" "info_teleport_destination"
"origin" "128 0 16"
"targetname" "$teleport_dest_tag$"
}
{
"classname" "$monster_class$"
"origin" "0 0 24"
"targetname" "$teleport_tag$"
}
"""

def main():

	qcrucible_init()

	_, next_target_num = qrucible_find_next_target_num()

	results_text = template_tele_monster

	# replace placeholders with actual values

	results_text = results_text.replace("$teleport_dest_tag$", qrucible_make_target_name(next_target_num))
	results_text = results_text.replace("$teleport_tag$", qrucible_make_target_name(next_target_num+1))
	results_text = results_text.replace("$monster_class$", "monster_"+qparams["monster_class"])

	# if the monster is NOT being spawned angry, remove it's "targetname" line.
	#
	# note: this is assumed to be the second to last line in the template. if
	# that changes, update this code!

	if qparams["spawn_angry"] == "false":

		lines = results_text.splitlines()
		if len(lines) >= 2:
			del lines[-2]
		results_text = "\n".join(lines)

	print(results_text)
	qrucible_emit_success("Copied to clipboard!")


if __name__ == "__main__":
	main()
